"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSameThreadWebWorkerFactory = exports.createWebWorkerFactory = void 0;
const events_1 = require("events");
const WebWorkerType_1 = __importDefault(require("./WebWorkerType"));
const webWorkerFactory_1 = require("./webWorkerFactory");
const WEB_WORKER_FILE_PATH = 'webWorker.js';
function createWebWorkerFactory(appVersion, createWebWorkerInstance) {
    return {
        createAppletTimingController: () => {
            return createWebWorker(WebWorkerType_1.default.APPLET_TIMING_CONTROLLER, appVersion, createWebWorkerInstance);
        },
    };
}
exports.createWebWorkerFactory = createWebWorkerFactory;
function createSameThreadWebWorkerFactory() {
    return {
        createAppletTimingController: () => {
            return createSameThreadWebWorker((postMessage) => (0, webWorkerFactory_1.createAppletTimingControllerWebWorker)(postMessage));
        },
    };
}
exports.createSameThreadWebWorkerFactory = createSameThreadWebWorkerFactory;
function createWebWorker(type, appVersion, createWebWorkerInstance) {
    // TODO make fallback for platforms that dont support web workers
    const webWorkerPath = WEB_WORKER_FILE_PATH + '?v=' + appVersion;
    const webWorker = createWebWorkerInstance ? createWebWorkerInstance() : new Worker(webWorkerPath);
    return {
        start: (initData) => webWorker.postMessage(createStartMessage(type, initData)),
        postMessage: (message) => webWorker.postMessage(createMessageMessage(message)),
        onMessage: (callback) => {
            webWorker.addEventListener('message', (event) => {
                switch (event.data.name) {
                    case 'console':
                        console[event.data.level](...event.data.args);
                        break;
                    case 'error':
                        const error = new Error(event.data.errorMessage);
                        error.name = event.data.errorName;
                        error.stack = event.data.errorStack;
                        throw error;
                    case 'message':
                        callback(event.data.message);
                        break;
                    default:
                        throw new Error('invalid message name: ' + event.data.name);
                }
            });
        },
    };
}
function createMessageMessage(message) {
    return { name: 'message', message };
}
function createStartMessage(type, initData) {
    return { name: 'start', type, initData };
}
function createSameThreadWebWorker(createWebWorkerLocal) {
    const eventEmitter = new events_1.EventEmitter();
    const webWorker = createWebWorkerLocal((message) => eventEmitter.emit('message', message));
    return {
        start: (initData) => webWorker.start(initData),
        postMessage: (message) => webWorker.onMessage(message),
        onMessage: (callback) => {
            eventEmitter.addListener('message', callback);
        },
    };
}
//# sourceMappingURL=masterWebWorkerFactory.js.map