import { IPrepareOptions } from './IVideoPlayer';
import { VideoEventType } from './IVideoEvent';
interface IVideo<TOptions extends IPrepareOptions = IPrepareOptions> {
    prepare(uri: string, x: number, y: number, width: number, height: number, options?: TOptions): Promise<void>;
    play(): Promise<void>;
    pause(): Promise<void>;
    resume(): Promise<void>;
    stop(): Promise<void>;
    addEventListener(eventName: VideoEventType, listener: () => void): void;
    removeAllEventListeners(): void;
    /** Returns duration of prepared video in milliseconds, throw error if not prepared or not supported */
    getDuration(): number;
}
export default IVideo;
