"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const ProprietaryVideoPlayer_1 = __importDefault(require("./ProprietaryVideoPlayer"));
const HTMLVideo_1 = __importDefault(require("./HTMLVideo"));
class HTMLVideoPlayer {
    constructor(maxAllowedVideos, window, foregroundWrapperElement = window.document.body, backgroundWrapperElement, getSystemVolume) {
        this.getSystemVolume = getSystemVolume;
        this.videos = this.createVideos(maxAllowedVideos, window, foregroundWrapperElement, backgroundWrapperElement);
        this.videoPlayer = new ProprietaryVideoPlayer_1.default(this.videos);
    }
    getMaxVideoCount() {
        return this.videoPlayer.getMaxVideoCount();
    }
    prepare(uri, x, y, width, height, options = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof options.volume === 'undefined' && this.getSystemVolume) {
                options.volume = yield this.getSystemVolume();
            }
            yield this.videoPlayer.prepare(uri, x, y, width, height, options);
        });
    }
    play(uri, x, y, width, height) {
        return this.videoPlayer.play(uri, x, y, width, height);
    }
    stop(uri, x, y, width, height) {
        return this.videoPlayer.stop(uri, x, y, width, height);
    }
    pause(uri, x, y, width, height) {
        return this.videoPlayer.pause(uri, x, y, width, height);
    }
    resume(uri, x, y, width, height) {
        return this.videoPlayer.resume(uri, x, y, width, height);
    }
    clearAll() {
        return this.videoPlayer.clearAll();
    }
    setVolume(volume) {
        for (let video of this.videos) {
            video.setVolume(volume);
        }
    }
    getDuration(uri, x, y, width, height) {
        return this.videoPlayer.getDuration(uri, x, y, width, height);
    }
    createVideos(maxAllowedVideos, window, foregroundWrapperElement, backgroundWrapperElement) {
        let videos = [];
        for (let i = 0; i < maxAllowedVideos; i++) {
            const video = new HTMLVideo_1.default(window, foregroundWrapperElement, backgroundWrapperElement);
            videos.push(video);
        }
        return videos;
    }
}
exports.default = HTMLVideoPlayer;
//# sourceMappingURL=HTMLVideoPlayer.js.map