import { IPrepareOptions } from './IVideoPlayer';
import IVideo from './IVideo';
export default class HTMLVideo implements IVideo {
    private window;
    private foregroundWrapperElement;
    private backgroundWrapperElement?;
    private videoWrapper;
    private video;
    private currentOptions;
    private eventEmitter;
    private endStreamWhenCannotReconnectDebounce;
    constructor(window: Window, foregroundWrapperElement?: HTMLElement, backgroundWrapperElement?: HTMLElement | undefined);
    play(): Promise<void>;
    stop(): Promise<void>;
    pause(): Promise<void>;
    resume(): Promise<void>;
    prepare(uri: string, x: number, y: number, width: number, height: number, options?: IPrepareOptions): Promise<void>;
    addEventListener(eventName: 'playing' | 'ended' | 'stopped' | 'error', listener: () => void): void;
    removeAllEventListeners(): void;
    setVolume(volumePercentage: number): void;
    getDuration(): number;
    private playVideo;
    private playVideoMutedFallback;
    /**
     * This method loads video wrapped by this HTML video class.
     *
     * Set src and load has to be called in one tick otherwise our listeners logic is broken
     * by browser auto load behavior which we can not change.
     *
     * More on https://developer.mozilla.org/en-US/docs/Web/API/HTMLMediaElement/loadstart_event
     * and here https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video#attr-preload.
     */
    private setVideoSourceAndLoad;
    private hide;
    private show;
    private clearVideoTagStyle;
    private setupVideoObjectStyle;
    private initializeVideo;
    private endIfCannotRecover;
    private resetEventEmitter;
    private ifChromeLogWarningWithLinkToDocs;
    private prepareSequenceListeners;
    private debugVideo;
}
