"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.retriable = void 0;
const progressiveWait_1 = require("@signageos/lib/dist/Timer/progressiveWait");
function retriable(options) {
    return function (_target, _propertyKey, descriptor) {
        const originalMethod = descriptor.value;
        descriptor.value = function (...args) {
            return __awaiter(this, void 0, void 0, function* () {
                const progressiveWait = (0, progressiveWait_1.createProgressiveWait)(options.initialTimeoutMs, options.progressiveMultiplier, options.maxTimeoutMs);
                for (let i = 0; i < options.count || options.count === -1; i++) {
                    try {
                        return yield originalMethod.apply(this, args);
                    }
                    catch (error) {
                        console.error(`Retrying ${originalMethod.name}(${args}) failed for ${i + 1} time`, error);
                        yield progressiveWait.wait();
                    }
                }
            });
        };
    };
}
exports.retriable = retriable;
//# sourceMappingURL=retriableDecorator.js.map