"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rejectOnceEvent = exports.resolveOnceEvent = void 0;
function resolveOnceEvent(eventEmitter, event) {
    return new Promise((resolve) => {
        eventEmitter.once(event, resolve);
    });
}
exports.resolveOnceEvent = resolveOnceEvent;
function rejectOnceEvent(eventEmitter, event) {
    return new Promise((_resolve, reject) => {
        eventEmitter.once(event, reject);
    });
}
exports.rejectOnceEvent = rejectOnceEvent;
//# sourceMappingURL=promise.js.map