"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.extendWindowSosSnippet = exports.extendWindowSos = exports.isSignageOsSymbol = void 0;
exports.isSignageOsSymbol = Symbol('sos');
const extendWindowSos = (property, value, windowObject = window) => {
    if (windowObject.sos && !windowObject.sos[exports.isSignageOsSymbol]) {
        throw new Error('Unable to create window.sos object, different property sos already exists on window');
    }
    if (windowObject.sos === undefined) {
        windowObject.sos = {};
        Object.defineProperty(windowObject.sos, exports.isSignageOsSymbol, { value: true });
    }
    windowObject.sos[property] = value;
};
exports.extendWindowSos = extendWindowSos;
const extendWindowSosSnippet = (snippet, windowObject = window) => {
    var _a;
    let initialized = false;
    const init = snippet.init;
    (0, exports.extendWindowSos)('snippet', Object.assign(Object.assign({}, snippet), { init: (options) => __awaiter(void 0, void 0, void 0, function* () {
            if (initialized) {
                console.warn('initSnippet was called multiple times, ignoring the excess calls');
                return;
            }
            initialized = true;
            return init(options);
        }) }), windowObject);
    (_a = windowObject === null || windowObject === void 0 ? void 0 : windowObject.addEventListener) === null || _a === void 0 ? void 0 : _a.call(windowObject, 'DOMContentLoaded', () => {
        // wait for a moment so user defined DOMContentLoaded listeners run first
        setTimeout(() => {
            if ('__SOS_AUTO_VERIFICATION' in windowObject && !initialized) {
                console.warn([
                    'Using snippet without sos.snippet.init() is deprecated, __SOS_AUTO_VERIFICATION variable and use please run sos.snippet.init() before or on DOMContentLoaded.',
                    'https://docs.signageos.io/hc/en-us/articles/4405556589458-Snippet-Provisioning',
                ].join('\n'));
                init();
            }
        }, 50);
    });
};
exports.extendWindowSosSnippet = extendWindowSosSnippet;
//# sourceMappingURL=extendWindowSos.js.map