export declare const isSignageOsSymbol: unique symbol;
declare global {
    interface WindowSosSnippet {
        init: (options?: SnippetOptions) => Promise<void>;
    }
    interface Window {
        sos: {
            snippet: WindowSosSnippet;
        };
    }
    var window: Window & typeof globalThis;
}
export interface SnippetOptions {
    autoVerification?: {
        organizationUid: string;
        deviceName?: string;
    };
}
export declare const extendWindowSos: <T extends "snippet">(property: T, value: {
    snippet: WindowSosSnippet;
}[T], windowObject?: Partial<Window>) => void;
export declare const extendWindowSosSnippet: (snippet: Omit<WindowSosSnippet, 'defer'>, windowObject?: Partial<Window>) => void;
