"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const effects_1 = require("redux-saga/effects");
/**
 * Forwarding results of generator or async generator to parent Saga by iterating over it and
 * if it returns Promise instead of value returns Delay effect until the Promise will be resolved.
 * Supports Redux-Saga effects at all.
 */
function* asyncCall(fn, ...params) {
    const iterator = fn(...params);
    if (typeof iterator.next !== 'function') {
        return iterator;
    }
    while (true) {
        const resultOrPromise = iterator.next();
        if (typeof resultOrPromise.then === 'function') {
            let resolved = false, finalResult = undefined, finalException = undefined;
            resultOrPromise
                .then((result) => {
                finalResult = result;
            })
                .catch((e) => {
                finalException = e;
            })
                .finally(() => {
                resolved = true;
            });
            while (!resolved) {
                yield (0, effects_1.delay)(10);
            }
            if (finalException) {
                throw finalException;
            }
            else if (finalResult.done) {
                return finalResult.value;
            }
            yield finalResult.value;
            continue;
        }
        else if (resultOrPromise.done) {
            return resultOrPromise.value;
        }
        yield resultOrPromise.value;
    }
}
exports.default = asyncCall;
//# sourceMappingURL=asyncCall.js.map