import { CallEffect, SagaReturnType } from 'redux-saga/effects';
type AsyncCallReturn<TFn extends (...params: any[]) => any> = SagaReturnType<TFn> | CallEffect<true>;
/**
 * Forwarding results of generator or async generator to parent Saga by iterating over it and
 * if it returns Promise instead of value returns Delay effect until the Promise will be resolved.
 * Supports Redux-Saga effects at all.
 */
export default function asyncCall<Fn extends (...params: any[]) => any>(fn: Fn, ...params: Parameters<Fn>): Generator<Parameters<Fn> | AsyncCallReturn<Fn>, AsyncCallReturn<Fn>, AsyncCallReturn<Fn>>;
export {};
