"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLocation = void 0;
function getLocation(href) {
    const match = href.match(/^(https?\:)\/\/(([^:\/?#]*)(?:\:([0-9]+))?)([\/]{0,1}[^?#]*)(\?[^#]*|)(#.*|)$/);
    return (match && {
        protocol: match[1],
        host: match[2],
        hostname: match[3],
        port: match[4],
        pathname: match[5],
        search: match[6],
        hash: match[7],
    });
}
exports.getLocation = getLocation;
//# sourceMappingURL=urlParser.js.map