"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
const convertWeekday_1 = require("@signageos/lib/dist/Timer/convertWeekday");
class TimerPropertyStorage {
    constructor(propertyStorage, property) {
        this.propertyStorage = propertyStorage;
        this.property = property;
    }
    /** @deprecated use replaceTimerSettings instead */
    replaceTimers(newTimers) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.replaceShortTimers(this.convertTimers(newTimers));
        });
    }
    replaceShortTimers(timers) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.saveTimersToStorage(Object.assign({}, timers));
        });
    }
    /** @deprecated use setTimerSettings instead */
    setTimer(newTimer) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.setShortTimer(this.convertTimer(newTimer));
        });
    }
    setShortTimer(timer) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.saveTimersToStorage(Object.assign(Object.assign({}, this.convertTimers(yield this.retrieveTimersFromStorage())), { [timer.type]: timer }));
        });
    }
    /** @deprecated use getTimerSettings instead */
    getTimer(timerType) {
        return __awaiter(this, void 0, void 0, function* () {
            const timers = yield this.getTimers();
            return timers[timerType];
        });
    }
    getShortTimer(timerType) {
        return __awaiter(this, void 0, void 0, function* () {
            let timers = yield this.getShortTimers();
            return timers[timerType];
        });
    }
    /** @deprecated use getTimerSettings instead */
    getTimers() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.convertToDeprecatedTimers(yield this.retrieveTimersFromStorage());
        });
    }
    getShortTimers() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.convertTimers(yield this.retrieveTimersFromStorage());
        });
    }
    /** @deprecated use deleteTimerSettings instead */
    deleteTimer(timerType) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.deleteShortTimer(timerType);
        });
    }
    deleteShortTimer(timerType) {
        return __awaiter(this, void 0, void 0, function* () {
            const timers = yield this.getShortTimers();
            delete timers[timerType];
            this.saveTimersToStorage(timers);
        });
    }
    saveTimersToStorage(timers) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.propertyStorage.setValue(this.property, timers);
        });
    }
    retrieveTimersFromStorage() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.propertyStorage.getValueOrDefault(this.property, {});
        });
    }
    convertTimers(timers) {
        return Object.fromEntries(Object.entries(timers).map(([k, v]) => [
            k,
            'weekdays' in v ? v : this.convertTimer(v),
        ]));
    }
    convertTimer(t) {
        const { sun, mon, tue, wed, thu, fri, sat } = t, rest = __rest(t, ["sun", "mon", "tue", "wed", "thu", "fri", "sat"]);
        return Object.assign(Object.assign({}, rest), { weekdays: convertWeekday_1.convertWeekday.fromLegacy({ sun, mon, tue, wed, thu, fri, sat }).toShort() });
    }
    /** @deprecated for BC only */
    convertToDeprecatedTimers(timers) {
        return Object.fromEntries(Object.entries(timers).map(([k, v]) => [
            k,
            'weekdays' in v ? this.convertToDeprecatedTimer(v) : v,
        ]));
    }
    /** @deprecated for BC only */
    convertToDeprecatedTimer(_a) {
        var { weekdays } = _a, rest = __rest(_a, ["weekdays"]);
        return Object.assign(Object.assign({}, rest), convertWeekday_1.convertWeekday.fromShort(weekdays).toLegacy());
    }
}
exports.default = TimerPropertyStorage;
//# sourceMappingURL=TimerPropertyStorage.js.map