import { ProprietaryTimerType } from '@signageos/common-types/dist/Device/Timer/ProprietaryTimerType';
import { NativeTimerType } from '@signageos/common-types/dist/Device/Timer/NativeTimerType';
import { ILegacyTimer } from '@signageos/lib/dist/Timer/Power/PowerTimerSettings';
import CommonTimerType from '@signageos/lib/dist/Timer/Power/PowerTimerType';
import { IPropertyStorage } from '../Property/propertyStorage';
import ITimerStorage, { TimersSettingsObject } from './ITimerStorage';
import Property from '../Property/Property';
import { IShortWeekdayTimer } from '@signageos/common-types/dist/Device/Settings/DeviceSettings';
export default class TimerPropertyStorage<T extends IShortWeekdayTimer, TKey extends ProprietaryTimerType | NativeTimerType> implements ITimerStorage<TKey, T> {
    private propertyStorage;
    private property;
    constructor(propertyStorage: IPropertyStorage, property: Property);
    /** @deprecated use replaceTimerSettings instead */
    replaceTimers(newTimers: TimersSettingsObject): Promise<void>;
    replaceShortTimers(timers: Partial<Record<TKey, T>>): Promise<void>;
    /** @deprecated use setTimerSettings instead */
    setTimer(newTimer: ILegacyTimer): Promise<void>;
    setShortTimer(timer: T): Promise<void>;
    /** @deprecated use getTimerSettings instead */
    getTimer(timerType: CommonTimerType): Promise<ILegacyTimer | undefined>;
    getShortTimer(timerType: TKey): Promise<T | undefined>;
    /** @deprecated use getTimerSettings instead */
    getTimers(): Promise<TimersSettingsObject>;
    getShortTimers(): Promise<Record<TKey, T>>;
    /** @deprecated use deleteTimerSettings instead */
    deleteTimer(timerType: TKey): Promise<void>;
    deleteShortTimer(timerType: TKey): Promise<void>;
    private saveTimersToStorage;
    private retrieveTimersFromStorage;
    private convertTimers;
    private convertTimer;
    /** @deprecated for BC only */
    private convertToDeprecatedTimers;
    /** @deprecated for BC only */
    private convertToDeprecatedTimer;
}
