"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkTimer = void 0;
const dateTimeFactory_1 = require("@signageos/lib/dist/DateTime/dateTimeFactory");
const powerTimerComputer_1 = require("@signageos/lib/dist/Timer/Power/powerTimerComputer");
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const debug_1 = __importDefault(require("debug"));
const events_1 = require("events");
const IProprietaryTimerResolver_1 = require("./IProprietaryTimerResolver");
const debug = (0, debug_1.default)('@signageos/front-display:Timer:ProprietaryTimerManager');
const getCurrentDate = () => (0, dateTimeFactory_1.now)().toDate();
class ProprietaryTimerResolver {
    constructor(timersStorage, checkPeriod = 30 * 1e3, now = getCurrentDate, appletLastEnabled = true) {
        this.timersStorage = timersStorage;
        this.checkPeriod = checkPeriod;
        this.now = now;
        this.appletLastEnabled = appletLastEnabled;
        this.eventEmitter = new events_1.EventEmitter();
        this.hasStartedListening = false;
        // We expect exactly a single TimerEvent.TIMER_ON and a single TimerEvent.TIMER_OFF listener.
        this.eventEmitter.setMaxListeners(2);
    }
    on(event, listener) {
        this.eventEmitter.on(event, listener);
        if (!this.hasStartedListening) {
            this.hasStartedListening = true;
            this.timersChecking();
            // TODO Add cancelation mechanism and clean up after use.
        }
        return this;
    }
    emit(event) {
        this.eventEmitter.emit(event);
    }
    timersChecking() {
        return __awaiter(this, void 0, void 0, function* () {
            while (true) {
                debug('check timers now');
                try {
                    const now = this.now();
                    yield checkTimer(now, () => this.timersStorage.getShortTimers(), (event) => this.emit(event), (state) => this.setLastAppletState(state), this.appletLastEnabled);
                }
                catch (error) {
                    console.error('timerChecking failed', error);
                }
                yield (0, wait_1.default)(this.checkPeriod);
            }
        });
    }
    setLastAppletState(lastState) {
        return __awaiter(this, void 0, void 0, function* () {
            this.appletLastEnabled = lastState;
            return this.appletLastEnabled;
        });
    }
}
exports.default = ProprietaryTimerResolver;
function checkTimer(now, getTimers, emit, setLastAppletState, appletLastEnabled) {
    return __awaiter(this, void 0, void 0, function* () {
        const timers = yield getTimers();
        const lastTimerEvent = (0, powerTimerComputer_1.getLastTimerEvent)(timers, now);
        if (lastTimerEvent == null) {
            return;
        }
        const isTimerOn = lastTimerEvent.type === 'ON';
        const displayOn = appletLastEnabled;
        if (isTimerOn !== displayOn) {
            if (isTimerOn) {
                debug('emit timer on');
                yield setLastAppletState(true);
                emit(IProprietaryTimerResolver_1.TimerEvent.TIMER_ON);
            }
            if (!isTimerOn && !timers[lastTimerEvent.timerType].keepAppletRunning) {
                yield setLastAppletState(false);
                debug('emit timer off');
                emit(IProprietaryTimerResolver_1.TimerEvent.TIMER_OFF);
            }
        }
    });
}
exports.checkTimer = checkTimer;
//# sourceMappingURL=ProprietaryTimerResolver.js.map