"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const debug_1 = __importDefault(require("debug"));
const wait_1 = __importDefault(require("@signageos/lib/dist/Timer/wait"));
const IProprietaryTimerResolver_1 = require("./IProprietaryTimerResolver");
const powerTimerComputer_1 = require("@signageos/lib/dist/Timer/Power/powerTimerComputer");
const dateTimeFactory_1 = require("@signageos/lib/dist/DateTime/dateTimeFactory");
const debug = (0, debug_1.default)('@signageos/front-display:Timer:DisplayPowerTimerResolver');
const getCurrentDate = () => (0, dateTimeFactory_1.now)().toDate();
class DisplayPowerTimerResolver {
    constructor(getIsDisplayPowerOn, ProprietaryTimerResolver, checkPeriod = 30 * 1e3, timersStorage, now = getCurrentDate) {
        this.getIsDisplayPowerOn = getIsDisplayPowerOn;
        this.ProprietaryTimerResolver = ProprietaryTimerResolver;
        this.checkPeriod = checkPeriod;
        this.timersStorage = timersStorage;
        this.now = now;
        this.eventEmitter = new events_1.EventEmitter();
        this.hasStartedListening = false;
        // We expect exactly a single DisplayEvent.POWER_ON and a single DisplayEvent.POWER_OFF listener.
        this.eventEmitter.setMaxListeners(2);
    }
    on(event, listener) {
        this.eventEmitter.on(event, listener);
        if (!this.hasStartedListening) {
            this.hasStartedListening = true;
            this.displayEventEmitter();
            // TODO Add cancelation mechanism and clean up after use.
        }
        return this;
    }
    emit(event) {
        this.eventEmitter.emit(event);
    }
    displayEventEmitter() {
        return __awaiter(this, void 0, void 0, function* () {
            this.ProprietaryTimerResolver.on(IProprietaryTimerResolver_1.TimerEvent.TIMER_ON, () => __awaiter(this, void 0, void 0, function* () {
                const displayOn = yield this.getIsDisplayPowerOn();
                debug('emit display On');
                if (!displayOn) {
                    this.emit(IProprietaryTimerResolver_1.DisplayEvent.POWER_ON);
                }
            }));
            this.ProprietaryTimerResolver.on(IProprietaryTimerResolver_1.TimerEvent.TIMER_OFF, () => __awaiter(this, void 0, void 0, function* () {
                debug('emit display Off');
                const displayOn = yield this.getIsDisplayPowerOn();
                if (displayOn) {
                    this.emit(IProprietaryTimerResolver_1.DisplayEvent.POWER_OFF);
                }
            }));
            while (true) {
                let lastTimerEvent = (0, powerTimerComputer_1.getLastTimerEvent)(yield this.timersStorage.getShortTimers(), this.now());
                if (lastTimerEvent === null) {
                    return;
                }
                let isTimerOn = lastTimerEvent.type === 'ON';
                const displayOn = yield this.getIsDisplayPowerOn();
                if (isTimerOn !== displayOn) {
                    if (isTimerOn) {
                        this.emit(IProprietaryTimerResolver_1.DisplayEvent.POWER_ON);
                    }
                    else {
                        this.emit(IProprietaryTimerResolver_1.DisplayEvent.POWER_OFF);
                    }
                }
                yield (0, wait_1.default)(this.checkPeriod);
            }
        });
    }
}
exports.default = DisplayPowerTimerResolver;
//# sourceMappingURL=DisplayPowerTimerResolver.js.map