"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runTestsSaga = exports.runTestsCallback = void 0;
const socketActionCreator_1 = require("../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const deviceTestActions_1 = require("@signageos/actions/dist/Device/Test/deviceTestActions");
const devicePowerActionActions_1 = require("../Front/Device/Power/devicePowerActionActions");
const TestFramework_1 = require("./TestFramework");
function* runTestsCallback(testSuitePromises, action) {
    const uid = action.uid;
    const uniqueRequestedTests = action.tests.filter((elem, pos) => {
        return action.tests.indexOf(elem) === pos;
    });
    if (uniqueRequestedTests.length === 0) {
        return;
    }
    const processedTests = [];
    yield (0, effects_1.put)({ type: devicePowerActionActions_1.TriggerAppletOff });
    try {
        for (let testSuitePromise of testSuitePromises) {
            const testSuite = yield testSuitePromise;
            if (!testSuite || !testSuite.title) {
                throw new Error('Invalid test - no describe defined');
            }
            // ignore test that was not requested
            if (action.tests.indexOf(testSuite.title) < 0) {
                continue;
            }
            processedTests.push(testSuite.title);
            const result = yield (0, TestFramework_1.runTests)(testSuite);
            // mark failed when at least one test failed
            if (result.failed > 0) {
                yield (0, effects_1.put)({ type: deviceTestActions_1.TestFailed, uid, identifier: result.title, result });
                continue;
            }
            // mark as skipped only when all tests are skipped
            if (result.skipped === result.total) {
                yield (0, effects_1.put)({ type: deviceTestActions_1.TestSkipped, uid, identifier: result.title, result });
                continue;
            }
            yield (0, effects_1.put)({ type: deviceTestActions_1.TestSucceeded, uid, identifier: result.title, result });
        }
    }
    catch (error) {
        console.error('runTestsCallback: ', error);
    }
    finally {
        for (let unsupportedTest of uniqueRequestedTests) {
            if (processedTests.indexOf(unsupportedTest) < 0) {
                console.warn('unknown test requested:', unsupportedTest);
            }
        }
        yield (0, effects_1.put)({ type: devicePowerActionActions_1.TriggerAppletOn });
    }
}
exports.runTestsCallback = runTestsCallback;
function* runTestsSaga(tests) {
    yield (0, socketActionCreator_1.takeEveryAndBindWhenPlatform)(deviceTestActions_1.StartTestSuite, runTestsCallback, tests);
}
exports.runTestsSaga = runTestsSaga;
//# sourceMappingURL=testSagas.js.map