import { TestResult } from '@signageos/actions/dist/Device/Test/deviceTestActions';
declare enum TestItemType {
    TITLE = "Title",
    DESCRIBE = "Describe",
    TEST = "Test",
    BEFORE = "Before",
    BEFORE_EACH = "BeforeEach",
    AFTER = "After",
    AFTER_EACH = "AfterEach"
}
export interface TestItem<TRun> {
    type: TestItemType;
    title: string;
    run: () => TRun;
    timeout?: number;
}
export declare class Describe implements TestItem<IterableIterator<TestItem<any>>> {
    title: string;
    run: () => IterableIterator<TestItem<any>>;
    timeout?: number | undefined;
    type: TestItemType;
    constructor(title: string, run: () => IterableIterator<TestItem<any>>, timeout?: number | undefined);
}
export declare function describe(title: string, describeCallback: () => IterableIterator<TestItem<any>>, timeout?: number): Describe;
declare class It implements TestItem<Promise<void>> {
    title: string;
    run: () => Promise<void>;
    timeout?: number | undefined;
    type: TestItemType;
    constructor(title: string, run: () => Promise<void>, timeout?: number | undefined);
}
export declare function it(title: string, describeCallback: () => Promise<void>, timeout?: number): It;
export declare function skip(reason: string): void;
declare class Before implements TestItem<Promise<void>> {
    title: string;
    run: () => Promise<void>;
    timeout?: number | undefined;
    type: TestItemType;
    constructor(title: string, run: () => Promise<void>, timeout?: number | undefined);
}
export declare function before(title: string, describeCallback: () => Promise<void>, timeout?: number): Before;
declare class After implements TestItem<Promise<void>> {
    title: string;
    run: () => Promise<void>;
    timeout?: number | undefined;
    type: TestItemType;
    constructor(title: string, run: () => Promise<void>, timeout?: number | undefined);
}
export declare function after(title: string, describeCallback: () => Promise<void>, timeout?: number): After;
declare class BeforeEach implements TestItem<Promise<void>> {
    title: string;
    run: () => Promise<void>;
    timeout?: number | undefined;
    type: TestItemType;
    constructor(title: string, run: () => Promise<void>, timeout?: number | undefined);
}
export declare function beforeEach(title: string, describeCallback: () => Promise<void>, timeout?: number): BeforeEach;
declare class AfterEach implements TestItem<Promise<void>> {
    title: string;
    run: () => Promise<void>;
    timeout?: number | undefined;
    type: TestItemType;
    constructor(title: string, run: () => Promise<void>, timeout?: number | undefined);
}
export declare function afterEach(title: string, describeCallback: () => Promise<void>, timeout?: number): AfterEach;
export declare function runTests(suite: Describe): Promise<TestResult>;
export declare function createEmptyTestResult(title: string): TestResult;
export {};
