"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.commonSystemLogsSaga = void 0;
const effects_1 = require("redux-saga/effects");
const socketActions_1 = require("@signageos/actions/dist/Socket/socketActions");
const socketActions_2 = require("../Socket/socketActions");
const systemLogActionFactory_1 = require("./systemLogActionFactory");
const offlineActions_1 = require("../Offline/offlineActions");
const systemLogs_1 = require("@signageos/common-types/dist/Device/SystemLogs/systemLogs");
function* commonSystemLogsSaga() {
    yield (0, effects_1.takeEvery)(socketActions_2.SocketConnected, function* () {
        yield (0, effects_1.put)((0, systemLogActionFactory_1.createSystemLogAction)({
            type: systemLogs_1.SocketConnected,
        }));
    });
    yield (0, effects_1.takeEvery)(socketActions_1.SocketDisconnected, function* () {
        yield (0, effects_1.put)((0, systemLogActionFactory_1.createSystemLogAction)({
            type: systemLogs_1.SocketDisconnected,
        }));
    });
    yield (0, effects_1.takeEvery)(socketActions_2.SocketConnectionFailed, function* (action) {
        yield (0, effects_1.put)((0, systemLogActionFactory_1.createSystemLogAction)({
            type: systemLogs_1.SocketConnectionFailed,
            errorMessage: action.errorMessage,
        }));
    });
    yield (0, effects_1.takeEvery)(offlineActions_1.DeviceAlive, function* () {
        yield (0, effects_1.put)((0, systemLogActionFactory_1.createSystemLogAction)({
            type: systemLogs_1.DeviceAlive,
        }));
    });
}
exports.commonSystemLogsSaga = commonSystemLogsSaga;
//# sourceMappingURL=commonSystemLogsSagas.js.map