"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.tryGetPlatformVersionFromUserAgent = void 0;
const checksum_1 = require("../Hash/checksum");
class WebBrowserEmulatorSystemInfo {
    constructor(window) {
        this.window = window;
    }
    getModel() {
        return __awaiter(this, void 0, void 0, function* () {
            return this.window.navigator.platform;
        });
    }
    getSerialNumber() {
        return __awaiter(this, void 0, void 0, function* () {
            return (0, checksum_1.checksumString)(this.window.navigator.userAgent, 12).toUpperCase();
        });
    }
    getCpuUsage() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Not implemented');
        });
    }
    getMemoryUsage() {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Not implemented');
        });
    }
    getOSVersion() {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const navigator = this.window.navigator;
            let platform = navigator.platform;
            let platformVersion = (_a = tryGetPlatformVersionFromUserAgent(navigator.userAgent)) !== null && _a !== void 0 ? _a : '0.0';
            if (isNavigatorUAData(navigator)) {
                const platformObject = yield navigator.userAgentData.getHighEntropyValues(['platform', 'platformVersion']);
                platform = platformObject.platform;
                platformVersion = platformObject.platformVersion;
            }
            if (platform === 'Windows') {
                return getOSWindowsVersion(platformVersion);
            }
            else {
                return platformVersion;
            }
        });
    }
    getBrand() {
        return __awaiter(this, void 0, void 0, function* () {
            return 'signageOS';
        });
    }
    getOsName() {
        return __awaiter(this, void 0, void 0, function* () {
            // In the future we would like to return a Browser name and its version parsing
            // the user agent string using a library like: https://www.npmjs.com/package/ua-parser-js
            return 'WebBrowser';
        });
    }
}
exports.default = WebBrowserEmulatorSystemInfo;
function getOSWindowsVersion(platformVersion) {
    return __awaiter(this, void 0, void 0, function* () {
        const majorPlatformVersion = parseInt(platformVersion.split('.')[0]);
        if (majorPlatformVersion >= 13) {
            return '11';
        }
        else if (majorPlatformVersion > 0) {
            return '10';
        }
        else {
            return '7,8,8.1';
        }
    });
}
function isNavigatorUAData(navigator) {
    return 'userAgentData' in navigator;
}
/**
 * Examples:
 * "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/115.0"  ->  "10.15"
 * "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36"  ->  "10.15"
 * "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114" ->  "10.0"
 * "Mozilla/5.0 (Linux; Android 13; SM-S908B) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Mobile Safari/537.36" ->  "13"
 */
function tryGetPlatformVersionFromUserAgent(userAgent) {
    var _a, _b;
    let platformVersion = (_b = (_a = userAgent.match(/\([^)]*\s(\d+((\.|_)\d+)?)[^)]*\)/)) === null || _a === void 0 ? void 0 : _a[1]) === null || _b === void 0 ? void 0 : _b.replace(/_+/g, '.');
    return platformVersion !== null && platformVersion !== void 0 ? platformVersion : null;
}
exports.tryGetPlatformVersionFromUserAgent = tryGetPlatformVersionFromUserAgent;
//# sourceMappingURL=WebBrowserEmulatorSystemInfo.js.map