import ISystemInfo, { ISystemMemory } from '../NativeDevice/ISystemInfo';
export default class WebBrowserEmulatorSystemInfo implements ISystemInfo {
    private window;
    constructor(window: Window);
    getModel(): Promise<string>;
    getSerialNumber(): Promise<string>;
    getCpuUsage(): Promise<number>;
    getMemoryUsage(): Promise<ISystemMemory>;
    getOSVersion(): Promise<string>;
    getBrand(): Promise<string>;
    getOsName(): Promise<string>;
}
/**
 * Examples:
 * "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/115.0"  ->  "10.15"
 * "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36"  ->  "10.15"
 * "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114" ->  "10.0"
 * "Mozilla/5.0 (Linux; Android 13; SM-S908B) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Mobile Safari/537.36" ->  "13"
 */
export declare function tryGetPlatformVersionFromUserAgent(userAgent: string): string | null;
