"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSocketAndP2PSynchronizer = void 0;
const IPolymorphicSynchronizer_1 = require("./IPolymorphicSynchronizer");
const PolymorphicSynchronizer_1 = require("./PolymorphicSynchronizer");
const socketSynchronizerFactory_1 = require("../SocketSynchronizer/socketSynchronizerFactory");
/**
 * Creates polymorphic synchronizer that uses socket synchronizer and P2P synchronizer.
 *
 * Socket synchronizer will be the default when connect() is called without specifying synchronizer type.
 *
 * TODO make P2P synchronizer the default once we decide that it is stable enough.
 */
function createSocketAndP2PSynchronizer(socketSynchronizerServerUrl, getNativeDriver, p2pSynchronizer) {
    const socketSynchronizer = (0, socketSynchronizerFactory_1.createSocketSynchronizer)(socketSynchronizerServerUrl, getNativeDriver);
    const synchronizerMap = new Map();
    synchronizerMap.set(IPolymorphicSynchronizer_1.SynchronizerType.SyncServer, socketSynchronizer);
    synchronizerMap.set(IPolymorphicSynchronizer_1.SynchronizerType.P2PLocal, p2pSynchronizer);
    return new PolymorphicSynchronizer_1.PolymorphicSynchronizer(synchronizerMap);
}
exports.createSocketAndP2PSynchronizer = createSocketAndP2PSynchronizer;
//# sourceMappingURL=polymorphicSynchronizerFactory.js.map