import { IPolymorphicSynchronizer, SynchronizerType } from './IPolymorphicSynchronizer';
import ISynchronizer, { SynchronizerEvent, JoinGroupArgs, WaitArgs, BroadcastedValueArgs, SynchronizerEventCallback } from '../ISynchronizer';
/**
 * Allows to select from multiple synchronizer implementations at runtime.
 *
 * The particular implementation is selected by the connect() method.
 * Once it's connected, all the methods will adhere to that implementation.
 * Only one of the implementations should be used at a time.
 * Call close() to stop using the current implementation.
 * After calling close(), the connect() method can be used to select a different implementation.
 */
export declare class PolymorphicSynchronizer implements IPolymorphicSynchronizer {
    private synchronizers;
    private emitter;
    private currentType;
    /**
     * @param synchronizers A map of synchronizer implementations. The key is the type of the synchronizer.
     *                      The first synchronizer in the map will be used as the default synchronizer.
     */
    constructor(synchronizers: Map<SynchronizerType, ISynchronizer>);
    /**
     * Selects the synchronizer implementation to use and makes it connect to the sync network
     * @param serverUri The URI of the sync server to connect to. If not specified, the default sync server will be used.
     *                  Only applicable to the socket synchronizer.
     * @param type The type of the synchronizer to use. If not specified, the default synchronizer will be used.
     */
    connect(serverUri?: string | undefined, type?: SynchronizerType | undefined): Promise<void>;
    close(): Promise<void>;
    isConnected(): Promise<boolean>;
    joinGroup(args: JoinGroupArgs): Promise<void>;
    leaveGroup(groupName: string): Promise<void>;
    getDeviceIdentification(groupName: string): Promise<string | undefined>;
    wait(args: WaitArgs): Promise<unknown>;
    cancelWait(groupName: string): Promise<void>;
    broadcastValue(args: BroadcastedValueArgs): Promise<void>;
    isMaster(groupName: string): Promise<boolean>;
    addListener(event: SynchronizerEvent, listener: SynchronizerEventCallback): void;
    removeListener(event: SynchronizerEvent, listener: SynchronizerEventCallback): void;
    private listenToSynchronizerEvents;
    private stopListeningToSynchronizerEvents;
    private onGroupStatus;
    private onGroupLeft;
    private onBroadcastedValue;
    private onClosed;
    private getDefaultSynchronizerType;
    private getSynchronizerByType;
    private getCurrentSynchronizer;
    private closeSynchronizerIfConnected;
}
