import ISynchronizer from '../ISynchronizer';
export declare enum SynchronizerType {
    SyncServer = "sync-server",
    P2PLocal = "p2p-local"
}
/**
 * Extends the ISynchronizer interface with additional feature to select from multiple synchronizer implementations.
 *
 * The particular implementation is selected by the connect() method.
 * Once it's connected, all the methods will adhere to that implementation.
 * Only one of the implementations should be used at a time.
 * Call close() to stop using the current implementation.
 * After calling close(), the connect() method can be used to select a different implementation.
 */
export interface IPolymorphicSynchronizer extends ISynchronizer {
    /**
     * Selects the synchronizer implementation to use and makes it connect to the sync network
     * @param serverUri The URI of the sync server to connect to. If not specified, the default sync server will be used.
     *                  Only applicable to the socket synchronizer.
     * @param type The type of the synchronizer to use. If not specified, the default synchronizer will be used.
     */
    connect(serverUri?: string, type?: SynchronizerType): Promise<void>;
}
