"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createNodeP2PSynchronizer = void 0;
const NodeSocketSerializer_1 = require("../../PeerNetwork/Serializer/NodeSocketSerializer");
const PeerDiscoveryService_utils_1 = require("../../PeerNetwork/PeerDiscoveryService/PeerDiscoveryService.utils");
const tcp = __importStar(require("../../PeerNetwork/Socket/Tcp/tcpSocketFactory"));
const udpSocketFactory_1 = require("../../PeerNetwork/Socket/Udp/udpSocketFactory");
const p2pSynchronizerFactory_1 = require("./p2pSynchronizerFactory");
const defaultTcpSocketFactory = (port) => tcp.tcpSocketFactory({
    port,
    clientConnectionTimeoutMs: 10e3,
});
/**
 * Convenience factory to create and instance of P2PSynchronizer for node.js environment.
 */
function createNodeP2PSynchronizer({ udpPort, tcpPort, getDeviceUid, getLocalAddress, tcpSocketFactory, udpSocketFactory, }) {
    getLocalAddress = getLocalAddress || PeerDiscoveryService_utils_1.getLocalAddress;
    tcpSocketFactory = tcpSocketFactory || defaultTcpSocketFactory;
    udpSocketFactory = udpSocketFactory || udpSocketFactory_1.udpSocketFactory;
    const serializer = new NodeSocketSerializer_1.NodeSocketSerializer();
    return (0, p2pSynchronizerFactory_1.createP2PSynchronizer)({
        udpPort,
        tcpPort,
        getDeviceUid,
        getLocalAddress,
        tcpSocketFactory,
        udpSocketFactory,
        serializer,
    });
}
exports.createNodeP2PSynchronizer = createNodeP2PSynchronizer;
//# sourceMappingURL=nodeP2PSynchronizerFactory.js.map