/// <reference types="node" />
import { ITcpSocket } from '../../PeerNetwork/Socket/Tcp/ITcpSocket';
import { IUdpSocket } from '../../PeerNetwork/Socket/Udp/IUdpSocket';
/**
 * Convenience factory to create and instance of P2PSynchronizer for node.js environment.
 */
export declare function createNodeP2PSynchronizer({ udpPort, tcpPort, getDeviceUid, getLocalAddress, tcpSocketFactory, udpSocketFactory, }: {
    /**
     * Port for UDP communication
     * UDP communication is used for network discovery, i.e. to find other devices on the network
     */
    udpPort?: number;
    /**
     * Port for TCP communication
     * TCP communication is used for sending messages between devices
     */
    tcpPort?: number;
    getDeviceUid: () => Promise<string>;
    getLocalAddress?: () => Promise<string | null>;
    tcpSocketFactory?: (port: number) => Promise<ITcpSocket<Buffer>>;
    udpSocketFactory?: (port: number) => Promise<IUdpSocket<Buffer>>;
}): Promise<import("./P2PSynchronizer").P2PSynchronizer>;
