"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createClientP2PSynchronizer = void 0;
const ClientSocketSerializer_1 = require("../../PeerNetwork/Serializer/ClientSocketSerializer");
const p2pSynchronizerFactory_1 = require("./p2pSynchronizerFactory");
/**
 * Convenience factory to create and instance of P2PSynchronizer for client environment.
 */
function createClientP2PSynchronizer({ udpPort, tcpPort, getDeviceUid, getLocalAddress, tcpSocketFactory, udpSocketFactory, }) {
    const serializer = new ClientSocketSerializer_1.ClientSocketSerializer();
    return (0, p2pSynchronizerFactory_1.createP2PSynchronizer)({
        udpPort,
        tcpPort,
        getDeviceUid,
        getLocalAddress,
        tcpSocketFactory,
        udpSocketFactory,
        serializer,
    });
}
exports.createClientP2PSynchronizer = createClientP2PSynchronizer;
//# sourceMappingURL=clientP2PSynchronizerFactory.js.map