import { PeerDiscoveryPeer } from '../../PeerNetwork/PeerDiscoveryService/IPeerDiscoveryService';
export type PeerCallback = (peer: PeerDiscoveryPeer) => void;
/**
 * WaitService handles synchronization of runtime with others in the network via wait interface
 */
export interface IWaitService {
    start(): void;
    stop(): void;
    /**
     * Wait for others and decide, who's data will be returned as the only true data.
     *
     * Once this method is called, it will block and wait for others to call this same method
     * (or follow the same communication protocol that this method implements).
     */
    sendWaitMessageAndWaitForOthers(data: unknown): Promise<unknown>;
    /**
     * Cancel currently pending wait
     *
     * Pending wait will reject with error
     */
    cancelWait(): Promise<void>;
}
