import { IStreamPrepareOptions, ITrackInfo } from './IStreamPlayer';
interface IStreamEvent<Type extends String> {
    type: Type;
}
export declare const StreamError = "Stream.Error";
export interface StreamError extends IStreamEvent<typeof StreamError> {
    uri: string;
    x: number;
    y: number;
    width: number;
    height: number;
    protocol?: Pick<IStreamPrepareOptions, 'protocol'>;
    errorMessage: string;
}
export declare const StreamConnected = "Stream.Connected";
export interface StreamConnected extends IStreamEvent<typeof StreamConnected> {
    uri: string;
    x: number;
    y: number;
    width: number;
    height: number;
    protocol?: Pick<IStreamPrepareOptions, 'protocol'>;
}
export declare const StreamDisconnected = "Stream.Disconnected";
export interface StreamDisconnected extends IStreamEvent<typeof StreamDisconnected> {
    uri: string;
    x: number;
    y: number;
    width: number;
    height: number;
    protocol?: Pick<IStreamPrepareOptions, 'protocol'>;
}
export declare const StreamTracksChanged = "Stream.TracksChanged";
export interface StreamTracksChanged extends IStreamEvent<typeof StreamTracksChanged> {
    uri: string;
    x: number;
    y: number;
    width: number;
    height: number;
    tracks: ITrackInfo[];
}
export {};
