"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/front-display:Stream:ProprietaryStreamPlayer');
class ProprietaryStreamPlayer {
    constructor(video) {
        this.video = video;
    }
    prepare(uri, x, y, width, height, options) {
        return this.video.prepare(uri, x, y, width, height, options);
    }
    play(uri, x, y, width, height, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const video = yield this.video.play(uri, x, y, width, height);
            const stream = new events_1.EventEmitter();
            setTimeout(() => stream.emit('connected', {
                type: 'connected',
                uri,
                x,
                y,
                width,
                height,
                protocol: options.protocol,
            }), 200);
            video.once('error', () => {
                stream.emit('error', {
                    type: 'error',
                    uri,
                    x,
                    y,
                    width,
                    height,
                    protocol: options.protocol,
                    errorMessage: 'Stream playback failed',
                });
            });
            video.once('stopped', () => {
                stream.emit('closed', {
                    type: 'closed',
                    uri,
                    x,
                    y,
                    width,
                    height,
                    protocol: options.protocol,
                });
            });
            video.once('ended', () => {
                stream.emit('disconnected', {
                    type: 'disconnected',
                    uri,
                    x,
                    y,
                    width,
                    height,
                    protocol: options.protocol,
                });
            });
            return stream;
        });
    }
    stop(uri, x, y, width, height) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.video.stop(uri, x, y, width, height);
        });
    }
    pause(uri, x, y, width, height) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.video.pause(uri, x, y, width, height);
        });
    }
    resume(uri, x, y, width, height) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.video.resume(uri, x, y, width, height);
        });
    }
    clearAll() {
        return __awaiter(this, void 0, void 0, function* () {
            debug('proprietary stream has nothing to clear');
        });
    }
    getTracks(_videoId) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Method getTracks not implemented.');
        });
    }
    selectTrack(_videoId, _trackType, _groupId, _trackIndex) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Method selectTrack not implemented.');
        });
    }
    resetTrack(_videoId, _trackType, _groupId) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error('Method resetTrack not implemented.');
        });
    }
}
exports.default = ProprietaryStreamPlayer;
//# sourceMappingURL=ProprietaryStreamPlayer.js.map