import IStreamPlayer, { IStreamOptions, IStreamPrepareOptions, ITrackInfo, TrackType } from './IStreamPlayer';
import IStream from './IStream';
import IVideoPlayer from '../Video/IVideoPlayer';
import { IVideoSrcArguments } from '../Video/IVideoSrcArguments';
declare class ProprietaryStreamPlayer implements IStreamPlayer {
    private video;
    constructor(video: IVideoPlayer);
    prepare(uri: string, x: number, y: number, width: number, height: number, options?: IStreamPrepareOptions): Promise<void>;
    play(uri: string, x: number, y: number, width: number, height: number, options: IStreamOptions): Promise<IStream>;
    stop(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    pause(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    resume(uri: string, x: number, y: number, width: number, height: number): Promise<void>;
    clearAll(): Promise<void>;
    getTracks(_videoId: IVideoSrcArguments): Promise<ITrackInfo[]>;
    selectTrack(_videoId: IVideoSrcArguments, _trackType: TrackType, _groupId: string, _trackIndex: number): Promise<void>;
    resetTrack(_videoId: IVideoSrcArguments, _trackType: TrackType, _groupId?: string): Promise<void>;
}
export default ProprietaryStreamPlayer;
