"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
class FileSystemStorage {
    constructor(fileSystem) {
        this.fileSystem = fileSystem;
    }
    getItem(key) {
        return __awaiter(this, void 0, void 0, function* () {
            const filePath = yield this.getFilePath(key);
            if (yield this.fileSystem.exists(filePath)) {
                return yield this.fileSystem.readFile(filePath);
            }
            else {
                return null;
            }
        });
    }
    setItem(key, data) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.ensureParentDir();
            const filePath = yield this.getFilePath(key);
            yield this.fileSystem.writeFile(filePath, data);
        });
    }
    removeItem(key) {
        return __awaiter(this, void 0, void 0, function* () {
            const filePath = yield this.getFilePath(key);
            if (yield this.fileSystem.exists(filePath)) {
                yield this.fileSystem.deleteFile(filePath, false);
            }
        });
    }
    clear() {
        return __awaiter(this, void 0, void 0, function* () {
            const parentDirPath = yield this.getParentDirPath();
            yield this.fileSystem.deleteFile(parentDirPath, true);
        });
    }
    ensureParentDir() {
        return __awaiter(this, void 0, void 0, function* () {
            const parentDirPath = yield this.getParentDirPath();
            if (!(yield this.fileSystem.exists(parentDirPath))) {
                yield this.fileSystem.createDirectory(parentDirPath);
            }
        });
    }
    getFilePath(key) {
        return __awaiter(this, void 0, void 0, function* () {
            const internalStorageUnit = yield this.getInternalStorageUnit();
            return {
                filePath: path_1.posix.join(FileSystemStorage.DIRNAME, key),
                storageUnit: internalStorageUnit,
            };
        });
    }
    getParentDirPath() {
        return __awaiter(this, void 0, void 0, function* () {
            const internalStorageUnit = yield this.getInternalStorageUnit();
            return {
                filePath: FileSystemStorage.DIRNAME,
                storageUnit: internalStorageUnit,
            };
        });
    }
    getInternalStorageUnit() {
        return __awaiter(this, void 0, void 0, function* () {
            const storageUnits = yield this.fileSystem.listStorageUnits();
            const internalStorageUnit = storageUnits.find((storageUnit) => !storageUnit.removable);
            if (!internalStorageUnit) {
                throw new Error("Internal storage isn't available");
            }
            return internalStorageUnit;
        });
    }
}
FileSystemStorage.DIRNAME = '.localStorage';
exports.default = FileSystemStorage;
//# sourceMappingURL=FileSystemStorage.js.map