"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const PREFIX = 'CategorizedLocalStorage';
class CategorizedLocalStorage {
    constructor(storage, category) {
        this.storage = storage;
        this.category = category;
        Object.defineProperty(this, 'storage', { enumerable: false });
        Object.defineProperty(this, 'category', { enumerable: false });
        this.getKeys().forEach((key) => this.defineItem(key));
    }
    get length() {
        return this.getKeys().length;
    }
    clear() {
        for (let key of this.getKeys()) {
            this.removeItem(key);
        }
    }
    getItem(key) {
        const value = this.storage.getItem(this.getKey(key));
        return typeof value !== 'undefined' ? value : null;
    }
    removeItem(key) {
        this.storage.removeItem(this.getKey(key));
        this.undefineItem(key);
    }
    setItem(key, data) {
        this.storage.setItem(this.getKey(key), '' + data);
        this.defineItem(key);
    }
    key(index) {
        return this.getKeys()[index];
    }
    getKeys() {
        return Object.keys(this.storage)
            .filter((key) => key.indexOf(this.getPrefix()) === 0)
            .map((key) => key.substring(this.getPrefix().length));
    }
    getKey(key) {
        return this.getPrefix() + key;
    }
    getPrefix() {
        return PREFIX + '$' + this.category + '$';
    }
    defineItem(key) {
        Object.defineProperty(this, key, {
            configurable: true,
            enumerable: true,
            get: () => this.getItem(key),
        });
    }
    undefineItem(key) {
        Object.defineProperty(this, key, {
            configurable: true,
            enumerable: false,
            writable: false,
            value: undefined,
        });
    }
}
exports.default = CategorizedLocalStorage;
//# sourceMappingURL=CategorizedLocalStorage.js.map