"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deliver = void 0;
const effects_1 = require("redux-saga/effects");
function* deliver(action) {
    const actionWithEmitter = yield (0, effects_1.put)(action);
    yield new Promise((resolve, reject) => {
        const timeout = setTimeout(() => reject(new Error(`Delivering action ${action.type} has timed out`)), 10e3);
        actionWithEmitter.__emitter.once('delivered', () => {
            clearTimeout(timeout);
            resolve();
        });
    });
    return action;
}
exports.deliver = deliver;
//# sourceMappingURL=socketActionDeliverHelper.js.map