import { HelperWorkerParameters } from 'redux-saga/effects';
import { ActionMatchingPattern } from '@redux-saga/types';
import { BindAction, UnbindAction } from './socketActions';
import { SagaIteratorWithPromises } from '../ReduxSaga/extendedEffects';
export declare const bindAndTakeEvery: <A extends string | string[], Fn extends (...args: unknown[]) => SagaIteratorWithPromises>(actionNames: A, saga: Fn, ...args: HelperWorkerParameters<ActionMatchingPattern<A>, Fn>) => import("redux-saga/effects").ForkEffect<any>;
/**
 * This function process actions and send them FROM server only when device is platform.
 * When device is open actions aren't process and then aren't send FROM server.
 */
export declare const bindAndTakeEveryOnlyWhenPlatform: <A extends string | string[], Fn extends (...args: unknown[]) => SagaIteratorWithPromises>(actionNames: A, saga: Fn, ...args: HelperWorkerParameters<ActionMatchingPattern<A>, Fn>) => import("redux-saga/effects").ForkEffect<any>;
/**
 * Actions are send FROM server only when device is platform.
 * @deprecated Use withDependencies instead and all will be bound correctly
 */
export declare const bindWhenPlatform: <P extends string | string[]>(actionNames: P) => import("redux-saga/effects").ForkEffect<Generator<import("redux-saga/effects").TakeEffect | Generator<import("redux-saga/effects").PutEffect<BindAction>, void, unknown> | Generator<import("redux-saga/effects").PutEffect<UnbindAction>, void, unknown>, never, unknown>>;
/**
 * This function process actions when device is platform or open.
 * Actions are send FROM server only when device is platform.
 */
export declare const takeEveryAndBindWhenPlatform: <P extends string | string[], Fn extends (...args: unknown[]) => SagaIteratorWithPromises>(actionNames: P, saga: Fn, ...args: HelperWorkerParameters<ActionMatchingPattern<P>, Fn>) => import("redux-saga/effects").ForkEffect<void>;
