"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const SupervisedServletProcess_1 = __importDefault(require("./SupervisedServletProcess"));
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/front-display:Servlet:SupervisedServletRunner');
const DEFAULT_HEALTHCHECK_TIMEOUT_MS = 30e3;
class SupervisedServletRunner {
    constructor(messageTypePrefix, baseServletRunner, defaultHealthcheckTimeoutMs = DEFAULT_HEALTHCHECK_TIMEOUT_MS) {
        this.messageTypePrefix = messageTypePrefix;
        this.baseServletRunner = baseServletRunner;
        this.defaultHealthcheckTimeoutMs = defaultHealthcheckTimeoutMs;
        this.servletProcesses = [];
    }
    run(entryPoint, options) {
        debug('run servlet', entryPoint, options);
        const runServletProcess = () => {
            var _a;
            const servletProcess = this.baseServletRunner.run(entryPoint, options);
            if ((_a = options === null || options === void 0 ? void 0 : options.healthcheck) === null || _a === void 0 ? void 0 : _a.enabled) {
                this.healthcheckServletProcess(servletProcess, options === null || options === void 0 ? void 0 : options.healthcheck);
            }
            return servletProcess;
        };
        const supervisedServletProcess = new SupervisedServletProcess_1.default(runServletProcess);
        this.servletProcesses.push(supervisedServletProcess);
        return supervisedServletProcess;
    }
    closeAll() {
        return __awaiter(this, void 0, void 0, function* () {
            debug('close all servlets');
            yield Promise.all(this.servletProcesses.map((servletProcess) => servletProcess.stop()));
        });
    }
    healthcheckServletProcess(servletProcess, healthcheckOptions) {
        debug('healthcheck servlet ' + servletProcess.getId());
        const timeoutMs = (healthcheckOptions === null || healthcheckOptions === void 0 ? void 0 : healthcheckOptions.timeoutMs) || this.defaultHealthcheckTimeoutMs;
        servletProcess.onMessage((message) => {
            if (message.type === this.messageTypePrefix + '_api.ready') {
                debug(`servlet ${servletProcess.getId()} ready, start healthchecking`);
                servletProcess.sendMessage({
                    type: this.messageTypePrefix + '.config.healthcheck',
                    healthcheck: Object.assign({ timeoutMs }, healthcheckOptions),
                });
            }
        });
        let timeoutHandler;
        let stopped = false;
        function resetTimeoutRestart() {
            if (!stopped) {
                debug(`reset servlet ${servletProcess.getId()} healthcheck timeout`);
                clearTimeout(timeoutHandler);
                timeoutHandler = setTimeout(() => __awaiter(this, void 0, void 0, function* () {
                    debug(`servlet ${servletProcess.getId()} healthcheck timed out and the servlet process will be stopped`);
                    stopped = true;
                    yield servletProcess.stop();
                }), timeoutMs);
            }
        }
        servletProcess.onMessage((message) => {
            debug(`servlet ${servletProcess.getId()} message received`, message);
            if (message.type === this.messageTypePrefix + '.ping') {
                // type .ping used in messages of front-applet (later front-servlet) lib
                // see pingHandler
                resetTimeoutRestart();
            }
            else {
                // Not handled any other messages now
            }
        });
        servletProcess.onceClosed(() => {
            stopped = true;
            clearTimeout(timeoutHandler);
        });
        resetTimeoutRestart();
    }
}
exports.default = SupervisedServletRunner;
//# sourceMappingURL=SupervisedServletRunner.js.map