import { IServletProcess, IServletProcessMessage } from './IServletRunner';
/**
 * Servlet process wrapper that ensures that the process is always running
 *
 * If it stops, it restarts it.
 * Inspired by https://wiki.gentoo.org/wiki/OpenRC/supervise-daemon
 */
export default class SupervisedServletProcess implements IServletProcess {
    private runProcess;
    private servletProcess;
    private eventEmitter;
    private closed;
    constructor(runProcess: () => IServletProcess);
    getId(): string;
    sendMessage<T extends IServletProcessMessage>(message: T): void;
    onMessage(messageListener: (message: IServletProcessMessage) => void): () => void;
    onceClosed(listener: () => void): void;
    stop(): Promise<void>;
    private runAndSuperviseServletProcess;
}
