"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerServiceWorker = void 0;
const eventsHelper_1 = require("../Events/eventsHelper");
const Cache_1 = require("./Cache");
function registerServiceWorker(window) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!window.navigator.serviceWorker || !window.caches) {
            console.warn(`ServiceWorker or Cache API is not supported by this browser.`);
            return null;
        }
        const [registration] = yield Promise.all([registerAndUpdateServiceWorker(window.navigator.serviceWorker), cacheAppFiles(window.caches)]);
        return registration;
    });
}
exports.registerServiceWorker = registerServiceWorker;
function registerAndUpdateServiceWorker(serviceWorkerContainer) {
    return __awaiter(this, void 0, void 0, function* () {
        yield (0, eventsHelper_1.waitForSuccessEventsOrFailEvents)(window, ['load'], []);
        const registration = yield serviceWorkerContainer.register('./serviceWorker.js', {
            updateViaCache: 'all',
        });
        console.info('ServiceWorker registration successful with scope: ', registration.scope);
        try {
            yield registration.update();
        }
        catch (error) {
            console.error('ServiceWorker registration update failed: ', error);
        }
        return registration;
    });
}
function cacheAppFiles(caches) {
    return __awaiter(this, void 0, void 0, function* () {
        const cache = yield caches.open(Cache_1.CacheName.FrontDisplay);
        const cachePaths = [
            './',
            'index.html',
            'webWorker.js',
            //'osd/*', // TODO add into cache all files in osd folder
        ];
        yield Promise.all(cachePaths.map((cachePath) => cache.add(cachePath).catch((error) => console.warn(`Failed to fetch "${cachePath}". Continue online.`, error))));
    });
}
//# sourceMappingURL=serviceWorkerLoader.js.map