"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const ISerial_1 = require("../NativeDevice/Hardware/ISerial");
const generator_1 = require("@signageos/lib/dist/Hash/generator");
const lockedDecorator_1 = require("../Lock/lockedDecorator");
class SerialPortStore {
    constructor(serial) {
        this.serial = serial;
        this.openSerialPorts = {};
        this.eventEmitter = new events_1.EventEmitter();
    }
    openSerialPort(options) {
        return __awaiter(this, void 0, void 0, function* () {
            const serialPort = yield this.serial.openPort(options);
            const refid = this.generateUniqueRefid();
            this.openSerialPorts[refid] = serialPort;
            serialPort.on(ISerial_1.SerialPortEvent.DATA, (data) => {
                this.eventEmitter.emit('data', refid, data);
            });
            serialPort.on(ISerial_1.SerialPortEvent.CLOSE, () => {
                this.eventEmitter.emit('close', refid);
            });
            return refid;
        });
    }
    writeToSerialPort(refid, data) {
        return __awaiter(this, void 0, void 0, function* () {
            const serialPort = this.getSerialPortByRefidOrThrowError(refid);
            yield serialPort.write(data);
        });
    }
    closeSerialPort(refid) {
        return __awaiter(this, void 0, void 0, function* () {
            const serialPort = this.getSerialPortByRefidOrThrowError(refid);
            yield serialPort.close();
            delete this.openSerialPorts[refid];
        });
    }
    closeAllSerialPorts() {
        return __awaiter(this, void 0, void 0, function* () {
            yield Promise.all(Object.keys(this.openSerialPorts).map((refid) => this.openSerialPorts[refid].close()));
            this.openSerialPorts = {};
        });
    }
    on(event, listener) {
        this.eventEmitter.addListener(event, listener);
    }
    removeEventListener(event, listener) {
        this.eventEmitter.removeListener(event, listener);
    }
    generateUniqueRefid() {
        let refid;
        do {
            refid = (0, generator_1.generateUniqueHash)(10);
        } while (this.openSerialPorts[refid]);
        return refid;
    }
    getSerialPortByRefidOrThrowError(refid) {
        const serialPort = this.openSerialPorts[refid];
        if (!serialPort) {
            throw new Error('refid not found');
        }
        return serialPort;
    }
}
exports.default = SerialPortStore;
__decorate([
    (0, lockedDecorator_1.locked)('SerialOpenStore'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], SerialPortStore.prototype, "openSerialPort", null);
__decorate([
    (0, lockedDecorator_1.locked)('SerialOpenStore'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], SerialPortStore.prototype, "closeSerialPort", null);
__decorate([
    (0, lockedDecorator_1.locked)('SerialOpenStore'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SerialPortStore.prototype, "closeAllSerialPorts", null);
//# sourceMappingURL=SerialPortStore.js.map