import ISerial, { IOptions } from '../NativeDevice/Hardware/ISerial';
import ISerialPortStore from './ISerialPortStore';
export default class SerialPortStore implements ISerialPortStore {
    private serial;
    private openSerialPorts;
    private eventEmitter;
    constructor(serial: ISerial);
    openSerialPort(options: IOptions): Promise<string>;
    writeToSerialPort(refid: string, data: string | number[] | Uint8Array): Promise<void>;
    closeSerialPort(refid: string): Promise<void>;
    closeAllSerialPorts(): Promise<void>;
    on(event: 'data', listener: (refid: string, data: Uint8Array) => void): void;
    on(event: 'close', listener: (refid: string) => void): void;
    removeEventListener(event: 'data' | 'close', listener: (...args: any[]) => void): void;
    private generateUniqueRefid;
    private getSerialPortByRefidOrThrowError;
}
