"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const debug_1 = __importDefault(require("debug"));
const debugDecorator_1 = require("@signageos/lib/dist/Debug/debugDecorator");
const DEBUG_NAMESPACE = '@signageos/front-display:Serial:SerialPort';
const logDebug = (0, debug_1.default)(DEBUG_NAMESPACE);
class SerialPort {
    constructor(serialPort) {
        this.serialPort = serialPort;
        this.eventEmitter = new events_1.EventEmitter();
        this.bindAndConvertDataEvents();
    }
    on(event, listener) {
        this.eventEmitter.on(event, listener);
    }
    removeListener(event, listener) {
        this.eventEmitter.removeListener(event, listener);
    }
    removeAllListeners(event) {
        if (event) {
            this.eventEmitter.removeAllListeners(event);
        }
        else {
            this.eventEmitter.removeAllListeners();
        }
    }
    write(data) {
        return new Promise((resolve, reject) => {
            let convertedData;
            if (data instanceof Uint8Array) {
                convertedData = Buffer.from(data);
            }
            else {
                convertedData = data;
            }
            this.serialPort.write(convertedData, (error) => {
                if (error) {
                    reject(error);
                }
                else {
                    resolve();
                }
            });
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.serialPort.isOpen) {
                yield this.drainSocket();
                yield this.closeSocket();
            }
        });
    }
    drainSocket() {
        return new Promise((resolve, reject) => {
            this.serialPort.drain((error) => {
                if (error) {
                    reject(error);
                }
                else {
                    resolve();
                }
            });
        });
    }
    closeSocket() {
        return new Promise((resolve, reject) => {
            this.serialPort.close((error) => {
                if (error) {
                    reject(error);
                }
                else {
                    resolve();
                }
            });
        });
    }
    bindAndConvertDataEvents() {
        this.serialPort.on('data', (data) => {
            logDebug(this.serialPort.path + ' data', data.toString());
            if (!Buffer.isBuffer(data)) {
                this.eventEmitter.emit('data', Buffer.from(data));
            }
            else {
                this.eventEmitter.emit('data', data);
            }
        });
        this.serialPort.on('close', () => {
            logDebug(this.serialPort.path + ' closed');
            this.eventEmitter.emit('close');
        });
    }
}
exports.default = SerialPort;
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], SerialPort.prototype, "write", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SerialPort.prototype, "close", null);
//# sourceMappingURL=SerialPort.js.map