import { BindingInterface } from '@serialport/bindings-interface';
import ISerial, { IOptions, ISerialPort } from '../NativeDevice/Hardware/ISerial';
export default class Serial implements ISerial {
    private openPorts;
    private readonly binding;
    /**
     * @param binding Defaults to platform bindings. Override for testing.
     */
    constructor(binding?: BindingInterface);
    openPort(options: IOptions): Promise<ISerialPort>;
    closeAll(): Promise<void>;
    private createAndOpenSerialPort;
    private prepareSerialPortOptions;
}
export declare function validateSerialPortOptions(options: IOptions, supportedOptions: (keyof IOptions)[]): void;
