"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createChannel = exports.takeEvery = void 0;
const effects_1 = require("redux-saga/effects");
const takeEvery = function* (channel, saga) {
    yield (0, effects_1.spawn)(function* () {
        while (true) {
            const message = yield (0, effects_1.call)(channel.take);
            yield (0, effects_1.fork)(saga, message);
        }
    });
};
exports.takeEvery = takeEvery;
function createChannel(executor) {
    const messageQueue = [];
    const resolveQueue = [];
    const rejectQueue = [];
    let open = true;
    function put(message) {
        if (resolveQueue.length) {
            const nextResolve = resolveQueue.shift();
            rejectQueue.shift();
            nextResolve(message);
        }
        else if (open) {
            messageQueue.push(message);
        }
    }
    function take() {
        if (messageQueue.length) {
            return Promise.resolve(messageQueue.shift());
        }
        else if (open) {
            return new Promise((resolve, reject) => {
                resolveQueue.push(resolve);
                rejectQueue.push(reject);
            });
        }
        else {
            return Promise.reject();
        }
    }
    function close() {
        open = false;
        while (resolveQueue.length > 0) {
            resolveQueue.shift();
            const nextReject = rejectQueue.shift();
            nextReject();
        }
    }
    if (executor) {
        executor(put);
    }
    return {
        take,
        put,
        close,
    };
}
exports.createChannel = createChannel;
//# sourceMappingURL=channels.js.map