"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createMemoryPropertyStorage = void 0;
function createMemoryPropertyStorage() {
    const memoryStorage = {};
    const propertyStorage = {
        getValueOrDefault(key, defaultValue) {
            var _a;
            return __awaiter(this, void 0, void 0, function* () {
                return (_a = memoryStorage[key]) !== null && _a !== void 0 ? _a : defaultValue;
            });
        },
        setValue(key, value) {
            return __awaiter(this, void 0, void 0, function* () {
                memoryStorage[key] = value;
            });
        },
        removeValue(key) {
            return __awaiter(this, void 0, void 0, function* () {
                delete memoryStorage[key];
            });
        },
    };
    return propertyStorage;
}
exports.createMemoryPropertyStorage = createMemoryPropertyStorage;
//# sourceMappingURL=memoryPropertyStorage.js.map