export declare enum UdpSocketEvent {
    Message = "message"
}
export type MessageListener<TMessage> = (message: TMessage) => void;
/**
 * UDP network socket that can broadcast messages to the network and receive messages
 */
export interface IUdpSocket<TMessage> {
    close(): Promise<void>;
    /** broadcast message to the network */
    send(message: TMessage): Promise<void>;
    addListener(event: UdpSocketEvent.Message, callback: MessageListener<TMessage>): void;
    removeListener(event: UdpSocketEvent.Message, callback: MessageListener<TMessage>): void;
}
