/// <reference types="node" />
import { ClosedListener, ITcpSocket, MessageListener, SendArgs, TcpSocketEvent } from './ITcpSocket';
export interface TcpSocketConfig {
    /** Server will listen on this port */
    port: number;
    /** Client connection will be only allowed to stay alive for this long. After that it will be killed. */
    clientConnectionTTLMs?: number;
    /** Client will only try for this long to establish a connection to a server. After that it will give up and throw an error. */
    clientConnectionTimeoutMs?: number;
}
export declare class TcpSocket implements ITcpSocket<Buffer> {
    private config;
    private emitter;
    private server;
    constructor(config: TcpSocketConfig);
    open(): Promise<void>;
    close(): Promise<void>;
    send(args: SendArgs<Buffer>): Promise<void>;
    addListener(event: TcpSocketEvent.Message, callback: MessageListener<Buffer>): void;
    addListener(event: TcpSocketEvent.Closed, callback: ClosedListener): void;
    removeListener(event: TcpSocketEvent.Message, callback: MessageListener<Buffer>): void;
    removeListener(event: TcpSocketEvent.Closed, callback: ClosedListener): void;
    private listenToServerEvents;
    private handleMessage;
}
