"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TcpServer = exports.TcpServerEvent = void 0;
const events_1 = require("events");
const net = __importStar(require("net"));
var TcpServerEvent;
(function (TcpServerEvent) {
    TcpServerEvent["Message"] = "message";
    TcpServerEvent["Closed"] = "closed";
})(TcpServerEvent || (exports.TcpServerEvent = TcpServerEvent = {}));
const DEFAULT_CLIENT_CONNECTION_TTL_MS = 5e3;
class TcpServer {
    constructor(port, clientConnectionTTLMs = DEFAULT_CLIENT_CONNECTION_TTL_MS) {
        this.port = port;
        this.clientConnectionTTLMs = clientConnectionTTLMs;
        this.emitter = new events_1.EventEmitter();
        this.server = new net.Server();
        this.listenToMessagesFromClients();
    }
    open() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.openServer();
            this.closeServerAndEmitClosedEventOnError();
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.closeServer();
        });
    }
    addListener(event, listener) {
        this.emitter.addListener(event, listener);
    }
    removeListener(event, listener) {
        this.emitter.removeListener(event, listener);
    }
    listenToMessagesFromClients() {
        this.server.on('connection', (socket) => {
            this.handleConnection(socket);
        });
    }
    handleConnection(socket) {
        const onDataListener = (data) => {
            this.handleMessage(data);
        };
        // prevent rogue clients from keeping the connection alive forever
        const timeout = setTimeout(() => socket.destroy(), this.clientConnectionTTLMs);
        socket.on('data', onDataListener);
        socket.on('close', () => {
            socket.removeListener('data', onDataListener);
            clearTimeout(timeout);
        });
    }
    handleMessage(message) {
        this.emitter.emit(TcpServerEvent.Message, message);
    }
    openServer() {
        return new Promise((resolve, reject) => {
            const cleanupListeners = () => {
                this.server.removeAllListeners('listening');
                this.server.removeAllListeners('error');
            };
            // cleanup potential listeners from previous runs
            cleanupListeners();
            this.server.once('listening', () => {
                cleanupListeners();
                resolve();
            });
            this.server.once('error', (error) => {
                cleanupListeners();
                reject(error);
            });
            this.server.listen(this.port);
        });
    }
    closeServerAndEmitClosedEventOnError() {
        this.server.once('error', (error) => {
            this.closeServer(error);
        });
    }
    closeServer(error) {
        return new Promise((resolve) => {
            this.server.close((closeError) => {
                if (closeError) {
                    console.warn('TcpServer closed with error', closeError);
                }
                this.emitter.emit(TcpServerEvent.Closed, error);
                resolve();
            });
        });
    }
}
exports.TcpServer = TcpServer;
//# sourceMappingURL=TcpServer.js.map