/// <reference types="node" />
export declare enum TcpServerEvent {
    Message = "message",
    Closed = "closed"
}
export type TcpServerMessageListener = (message: Buffer) => void;
export type TcpServerClosedListener = (error?: Error) => void;
export type TcpServerEventListener = TcpServerMessageListener | TcpServerClosedListener;
export declare class TcpServer {
    private port;
    private clientConnectionTTLMs;
    private emitter;
    private server;
    constructor(port: number, clientConnectionTTLMs?: number);
    open(): Promise<void>;
    close(): Promise<void>;
    addListener(event: TcpServerEvent.Message, listener: TcpServerMessageListener): void;
    addListener(event: TcpServerEvent.Closed, listener: TcpServerClosedListener): void;
    removeListener(event: TcpServerEvent.Message, listener: TcpServerMessageListener): void;
    removeListener(event: TcpServerEvent.Closed, listener: TcpServerClosedListener): void;
    private listenToMessagesFromClients;
    private handleConnection;
    private handleMessage;
    private openServer;
    private closeServerAndEmitClosedEventOnError;
    private closeServer;
}
