"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TcpClient = void 0;
const net = __importStar(require("net"));
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/front-display:Synchronization:Socket:TcpClient');
class TcpClient {
    constructor({ host, port, connectionTimeoutMs }) {
        this.debugId = Math.random().toString(36).substring(2, 9);
        this.host = host;
        this.port = port;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.socket = new net.Socket();
    }
    connect() {
        debug(`${this.debugId} connect to ${this.host}:${this.port}`);
        if (this.connectionTimeoutMs) {
            this.socket.setTimeout(this.connectionTimeoutMs);
        }
        return new Promise((resolve, reject) => {
            const cleanupListeners = () => {
                this.socket.removeAllListeners('connect');
                this.socket.removeAllListeners('error');
                this.socket.removeAllListeners('timeout');
            };
            this.socket.once('connect', () => {
                debug(`${this.debugId} successfully connected`);
                cleanupListeners();
                resolve();
            });
            this.socket.once('error', (error) => {
                debug(`${this.debugId} failed to connect`, error);
                cleanupListeners();
                reject(error);
            });
            this.socket.once('timeout', () => {
                debug(`${this.debugId} timeout`);
                cleanupListeners();
                this.socket.destroy();
                reject(new Error('socket timeout'));
            });
            this.socket.connect(this.port, this.host);
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            debug(`${this.debugId} closing`);
            yield new Promise((resolve) => {
                this.socket.end(() => {
                    debug(`${this.debugId} closed`);
                    resolve();
                });
            });
            this.socket.destroy();
        });
    }
    send(data) {
        return new Promise((resolve, reject) => {
            this.socket.write(data, (error) => {
                if (error) {
                    reject(error);
                }
                else {
                    resolve();
                }
            });
        });
    }
}
exports.TcpClient = TcpClient;
//# sourceMappingURL=TcpClient.js.map