import { ITcpSocket, SendArgs } from './ITcpSocket';
/**
 * Wrapper class for ITcpSocket that ensures that messages to the same destination are sent in order
 *
 * The reason for creation of this class is the following real-life scenario:
 * There were 2 devices, connected to the same Wi-Fi network. The network was slow.
 * Once in a while it happened that several messages were sent to the same device in a quick succession
 * and one of the messages was received by the other devices out of order.
 * In other words, device A sent messages 1, 2, and 3 and device B received them in the order 1, 3, 2.
 *
 * This class ensures that messages are sent in order, so that the above scenario doesn't happen.
 */
export declare class OrderedTcpSocket<TMessage> implements ITcpSocket<TMessage> {
    private baseTcpSocket;
    readonly addListener: ITcpSocket<TMessage>['addListener'];
    readonly removeListener: ITcpSocket<TMessage>['removeListener'];
    private lock;
    constructor(baseTcpSocket: ITcpSocket<TMessage>);
    close(): Promise<void>;
    send(args: SendArgs<TMessage>): Promise<void>;
    private getSendDestinationAsString;
}
