export declare enum TcpSocketEvent {
    Message = "message",
    Closed = "closed"
}
export interface SendArgs<TMessage> {
    message: TMessage;
    host: string;
    port: number;
}
export type MessageListener<TMessage> = (message: TMessage) => void;
export type ClosedListener = (error?: Error) => void;
export type TcpSocketEventListener<TMessage> = MessageListener<TMessage> | ClosedListener;
/**
 * Network socket that can send messages to the network and receive messages
 */
export interface ITcpSocket<TMessage> {
    close(): Promise<void>;
    send(args: SendArgs<TMessage>): Promise<void>;
    addListener(event: TcpSocketEvent.Message, callback: MessageListener<TMessage>): void;
    addListener(event: TcpSocketEvent.Closed, callback: ClosedListener): void;
    removeListener(event: TcpSocketEvent.Message, callback: MessageListener<TMessage>): void;
    removeListener(event: TcpSocketEvent.Closed, callback: ClosedListener): void;
}
